
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_LOTE_SNGPC_LOTE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_LOTE_SNGPC_LOTE]
GO
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_LOTE_SNGPC_LOTE](@CD_EMP INT = 1,
						  @CD_FILIAL INT = 0)
AS
/*
Objetivo: Inserir todos os registros de lotes do SNGPC que não existam na EST_PROD_CPL_LOTE.
OBS.: Possui filtro de filial.
*/
	SET NOCOUNT ON;
	DECLARE filiais CURSOR FAST_FORWARD FOR   
	SELECT CD_FILIAL   
	FROM PRC_FILIAL   
	WHERE CD_FILIAL = CASE WHEN @CD_FILIAL = 0 THEN CD_FILIAL ELSE @CD_FILIAL END;
	OPEN filiais  
	FETCH NEXT FROM filiais INTO @CD_FILIAL  
	WHILE @@FETCH_STATUS=0  
	begin  
		PRINT 'Inserindo lotes da filial '+ CONVERT(VARCHAR(5), @CD_FILIAL) + ' ---- (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')' 
		INSERT INTO EST_PROD_CPL_LOTE(CD_EMP
											,CD_FILIAL
											,CD_LOTE
											,CD_PROD
											,NR_LOTE
											,DT_VALID
											,QTDE_PROD
											,DT_FABR
											,DT_CAD
											,DT_FABRIC
											,CD_AGREGADOR
											,CD_USU 
											,CD_USU_ALT 
											,DT_ALT )
		SELECT A.CD_EMP, 
			   A.CD_FILIAL, 
			   A.CD_LOTE, 
			   B.CD_PROD, 
			   B.NR_LOTE, 
			   B.VALIDADE, 
			   0 AS QTDE_PROD, 
			   '20010101'as DT_FABR, 			  
			   B.DT_ULT_ALT AS DT_CAD, 
			   0 as DT_FABRIC,
			   0 AS CD_AGREGADOR
			   ,1
			   ,1
			   ,GETDATE()
		FROM EST_PROD_EST_SNGPC_LOTE_CPL A
			 INNER JOIN EST_PROD_EST_SNGPC_LOTE B ON A.CD_EMP = B.CD_EMP
													 AND A.CD_LOTE = B.CD_LOTE
			 INNER JOIN EST_PROD_EST_SNGPC C ON C.CD_EMP = B.CD_EMP
												AND C.CD_PROD = B.CD_PROD
			 LEFT OUTER JOIN EST_PROD_CPL_LOTE D ON A.CD_EMP = D.CD_EMP
													AND A.CD_FILIAL = D.CD_FILIAL
													AND A.CD_LOTE = D.CD_LOTE
		WHERE D.CD_EMP IS NULL
			  AND A.CD_FILIAL = @CD_FILIAL;
		FETCH NEXT FROM filiais INTO @CD_FILIAL  
	end  
PRINT 'Concluído.'  
CLOSE filiais  
DEALLOCATE filiais